unit Unit1;

interface

{==============================================================================}
{ This demo shows how to obtain list of checkpoints in document.               }
{ Key methods:                                                                 }
{ - GetFirstCheckpoint, GetNextCheckpoint;                                     }
{ - GetCheckpointInfo.                                                         }
{==============================================================================}
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, RVStyle, RVScroll, RichView, SclRView;

type
  TForm1 = class(TForm)
    RVStyle1: TRVStyle;
    ListBox1: TListBox;
    Button1: TButton;
    srv: TSRichViewEdit;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var i, j: Integer;
    CheckpointData : TCheckpointData;
    Name: String;
    RaiseEvent: Boolean;
    Tag: Integer;
begin
  srv.SetMargin(5, 5, 5, 5);

  // 1. Filling in RichView
  for i := 1 to 3 do begin
    srv.RichViewEdit.AddNamedCheckpoint('C'+IntToStr(i));
    srv.RichViewEdit.AddFmt('Chapter %d', [i], 1,1);
    for j := 0 to 30 do
      srv.RichViewEdit.AddNL('Bla - bla - bla - bla - bla - bla - bla - bla'+
                      '- bla - bla - bla - bla - bla - bla - bla - bla',0,0);
  end;
  srv.RichViewEdit.AddNamedCheckpoint('END');
  srv.RichViewEdit.Format;
  // 2. Filling in list of checkpoints
  CheckpointData :=  srv.RichViewEdit.GetFirstCheckpoint;
  if CheckpointData<>nil then begin
    repeat
      srv.RichViewEdit.GetCheckpointInfo(CheckpointData, Tag, Name, RaiseEvent);
      // Tag and RaiseEvent will be discussed in next demos
      ListBox1.Items.Add(Name);
      CheckpointData := srv.RichViewEdit.GetNextCheckpoint(CheckpointData);
    until CheckpointData=nil;
    ListBox1.ItemIndex := 0;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var CheckpointIndex: Integer;
    Y : Integer;
begin
  CheckpointIndex := ListBox1.ItemIndex;
  if CheckpointIndex=-1 then exit;

  Y := srv.RichViewEdit.GetCheckpointY(CheckpointIndex);
  Y := srv.convertRVtoSRV(Point(0, Y)).Y;
  srv.VScrollPos := Round(Y + srv.OffsetDocY) div srv.RichViewEdit.VSmallStep;
end;

end.
